<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.newsletter.newsletter')); ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css'); ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li><a href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
    <i class="icon-mail"></i><?php echo $view['translator']->trans('newsletter.listTitle'); ?> - <?php echo $view['translator']->trans('newsletter.listSubTitle'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleDesc'); ?>
    <?php echo $view['translator']->trans('newsletter.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="newsletter-tabs">
    <ul class="tabs" data-deep-link="true" data-update-history="true" data-deep-link-smudge="true" data-deep-link-smudge="500" data-tabs id="deeplinked-tabs">
        <li class="tabs-title is-active"><a href="#main" aria-selected="true"><i class="icon-mail"></i>Newsletter Campaigns</a></li>
        <li class="tabs-title"><a href="#recipient-groups" aria-selected="true"><i class="icon-folder-open-empty"></i>Recipient Groups</a></li>
        <li class="tabs-title"><a href="#senders" aria-selected="true"><i class="icon-paper-plane-empty"></i>Senders</a></li>
    </ul>

    <div class="tabs-content" data-tabs-content="deeplinked-tabs">
        <div class="tabs-panel is-active" id="main">
            <?php echo $view->render('WiAdminNewsLetterBundle:Newsletter:Components/main.html.php', [
                'activeCampaigns' => $activeCampaigns,
                'config' => $config,
                'notActiveCampaigns' => $notActiveCampaigns,
            ]); ?>
        </div>
        <div class="tabs-panel" id="recipient-groups">
            <?php echo $view->render('WiAdminNewsLetterBundle:Newsletter:Components/recipient_groups.html.php', [
                'recipientGroups' => $recipientGroups,
            ]); ?>
        </div>
        <div class="tabs-panel" id="senders">
            <?php echo $view->render('WiAdminNewsLetterBundle:Newsletter:Components/senders.html.php', [
                'senders' => $senders,
            ]); ?>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script>
    var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
</script>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js'); ?>"></script>
<script>
google.charts.load('current', {packages: ['corechart', 'bar']});

$(function () {
    statisticAjax();
});

function statisticAjax(type, date = '') {
    $.ajax({
        url: Routing.generate('wi_admin_newsletter_statistics'),
        method: 'GET',
        data: {
            'type': type,
            'date': date,
        },
        type: 'JSON',
        success: function (result) {
            campaignData = [];

            for (var i = result.data.length - 1; i >= 0; i--) {
                var res = result.data[i];
                campaignData.push([new Date(res.date), res.messages, res.tooltip]);
            }

            google.charts.setOnLoadCallback(draw);
        }
    });
}

function draw() {
    var data = new google.visualization.DataTable();
    data.addColumn('date', 'Hour');
    data.addColumn('number', 'Sent');
    data.addColumn({type: 'string', role: 'tooltip', 'p': {'html': true}});
    data.addRows(campaignData);

    var options = {
        hAxis: {
            title: 'Statistics',
            format: 'yyyy-MM-dd',
        },
        legend: 'none',
        isStacked: true,
        vAxis: {
            viewWindow: {
                min: 0
            },
        },
        tooltip: {isHtml: true},
    };

    var chart = new google.visualization.ColumnChart(document.getElementById('campaign-chart'));
    chart.draw(data, options);
}
</script>
<?php $view['slots']->stop(); ?>

