<?php

namespace Wi\Admin\NewsLetterBundle\Service;

class HashRecipientGroup
{
    private const KEY = 'fRAwRe5_e7aSTucrUSpAdeN_mA8arutH';
    private const ENCRYPT_METHOD = 'AES-128-CBC';
    private const IV = 'freSwagefreSwage';

    /**
     * Koduje ID i zwraca zakodowany hash.
     *
     * @param int $id
     * @return string
     */
    public function encode(int $id) : string
    {
        return base64_encode(openssl_encrypt($id, self::ENCRYPT_METHOD, self::KEY, 0, self::IV));
    }

    /**
     * Dekoduje hash i zwraca odkodowane ID.
     *
     * @param string $hash
     * @return int
     */
    public function decode(string $hash) : int
    {
        return openssl_decrypt(base64_decode($hash), self::ENCRYPT_METHOD, self::KEY, 0, self::IV);
    }
}
