<?php

namespace Wi\Admin\NewsLetterBundle\Service;

use Symfony\Bundle\FrameworkBundle\Templating\EngineInterface;

class Mailer
{
    public $message;
    private $mailer;
    private $sender;
    private $templating;
    private $bcc;

    public function __construct(EngineInterface $templating)
    {
        $this->templating = $templating;
    }

    public function init($params)
    {
        $this->setSender($params['sender']);
        $this->bcc = $params['bcc'];
        $this->setMailer();
        $this->setMessage();

        return $this;
    }

    public function send()
    {
        return $this->mailer->send($this->message);
    }

    public function renderMail($view, $params = [])
    {
        return $this->templating->render($view, array_merge($params, [
            'message' => $this->message,
            'subject' => $this->message->getSubject(),
        ]));
    }

    // ------------------------------------------------------------
    // Private functions
    // ------------------------------------------------------------

    private function setSender($sender)
    {
        $this->sender = $sender;

        return $this;
    }

    private function getTransport()
    {
        $transport = new \Swift_SmtpTransport();
        $transport
            ->setHost($this->sender->getSmtpHost())
            ->setUsername($this->sender->getSmtpLogin())
            ->setPassword($this->sender->getSmtpPassword())
        ;

        if ($this->sender->getSmtpPort()) {
            $transport->setPort($this->sender->getSmtpPort());
        }

        return $transport;
    }

    private function setMessage()
    {
        $from = $this->sender->getEmail();

        if (! empty($name = $this->sender->getName())) {
            $from = [$from => $name];
        }

        $this->message = (new \Swift_Message())
            ->setFrom($from)
        ;

        if (! empty($reply_to = $this->sender->getReplyTo())) {
            $this->message->setReplyTo($reply_to);
        }

        if ($this->bcc) {
            $this->message->setBcc($this->bcc);
        }
    }

    private function setMailer()
    {
        $this->mailer = new \Swift_Mailer($this->getTransport());

        return $this;
    }
}
