<?php

namespace Wi\Admin\NewsLetterBundle\Service;

use Wi\Admin\CoreBundle\Service\Mailer as BaseMailer;
use Wi\Admin\NewsLetterBundle\Entity\Recipients;

/**
 * Recipient mailer
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class RecipientMailer extends BaseMailer
{
    /**
     * Wysyła maila z linkiem do potwierdzenia adresu e-mail.
     *
     * @param Recipients $recipient
     * @return int
     */
    public function sendConfirmEmail(Recipients $recipient)
    {
        $this->message
            ->setTo($recipient->getEmail())
            ->setSubject('Potwierdź adres e-mail')
            ->setBody(
                $this->render('WiAdminNewsLetterBundle:templates:emails/confirm.html.twig', [
                    'recipient' => $recipient,
                ]),
                'text/html'
            )
        ;

        return $this->send();
    }
}
