<?php

namespace Wi\Admin\PageBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\PageBundle\Entity\Page;

/**
 * Załadowanie stron do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadPageData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $page = $this->getPage($data);
            $this->addReference('pb-page-'.$data['id'], $page);

            // Przygotowanie do zapisu.
            $manager->persist($page);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($page));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 17;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            [
                'id' => 1,
                'group' => 1,
                'title' => 'Strona główna',
                'content' => 'W budowie...',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'A',
            ],
            [
                'id' => 2,
                'group' => 1,
                'title' => 'Strona w budowie',
                'content' => 'W budowie...',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'A',
            ],
            [
                'id' => 3,
                'group' => 1,
                'title' => 'Kontakt',
                'content' => 'W budowie...',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'A',
            ],
            [
                'id' => 4,
                'group' => 1,
                'title' => 'Aktualności',
                'content' => 'W budowie...',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'A',
            ],
            [
                'id' => 5,
                'group' => 1,
                'title' => 'Regulamin',
                'content' => 'Regulamin (rejestracja użytkownika)',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'A',
            ],
            [
                'id' => 6,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 7,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 8,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 9,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 10,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 11,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 12,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 13,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 14,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 15,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 16,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 17,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 18,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 19,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
            [
                'id' => 20,
                'group' => 1,
                'title' => 'Zarezerwowane',
                'content' => 'Zarezerwowane',
                'visitCounter' => 0,
                'metaTitle' => null,
                'metaDescription' => null,
                'metaKeywords' => null,
                'metaCanonical' => null,
                'metaImage' => null,
                'status' => 'N',
            ],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\PageBundle\Entity\Page
     */
    private function getPage(array $data)
    {
        return (new Page())
            ->setId($data['id'])
            ->setGroup($this->getReference('pb-pageGroup-' . $data['group']))
            ->setTitle($data['title'])
            ->setContent($data['content'])
            ->setVisitCounter($data['visitCounter'])
            ->setDateCreated(new \DateTime())
            ->setMetaTitle($data['metaTitle'])
            ->setMetaDescription($data['metaDescription'])
            ->setMetaKeywords($data['metaKeywords'])
            ->setMetaCanonical($data['metaCanonical'])
            ->setMetaImage($data['metaImage'])
            ->setStatus($data['status'])
        ;
    }
}
