<?php

namespace Wi\Admin\PageBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\PageBundle\Entity\PageGroup;

/**
 * Załadowanie grup stron do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadPageGroupData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $pageGroup = $this->getPageGroup($data);
            $this->addReference('pb-pageGroup-'.$data['id'], $pageGroup);

            // Przygotowanie do zapisu.
            $manager->persist($pageGroup);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($pageGroup));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 16;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            [
                'id' => 1,
                'parent' => null,
                'orderNr' => 1,
                'name' => 'Predefiniowane',
            ],
            [
                'id' => 2,
                'parent' => null,
                'orderNr' => 2,
                'name' => 'Podstawowa grupa',
            ],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\PageBundle\Entity\PageGroup
     */
    private function getPageGroup(array $data)
    {
        return (new PageGroup())
            ->setId($data['id'])
            ->setParent((! is_null($data['parent']) ? $this->getReference('pb-pageGroup-' . $data['parent']) : null))
            ->setOrderNr($data['orderNr'])
            ->setName($data['name'])
            ->setDateCreated(new \DateTime())
            ->setStatus('A')
        ;
    }
}
