<?php

namespace Wi\Admin\PageBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;
use Wi\Admin\PageBundle\Entity\PageGroup;

/**
 * Page
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Table(
 *      name="pages",
 *      indexes={
 *          @ORM\Index(name="IX_Page_Group_id", columns={"group_id"})
 *      }
 * )
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Entity(repositoryClass="Wi\Admin\PageBundle\Repository\PageRepository")
 * @ORM\EntityListeners({"Wi\Admin\PageBundle\EventListener\Entity\PageListener"})
 * @Gedmo\SoftDeleteable(fieldName = "dateDeleted")
 */
class Page
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var Wi\Admin\PageBundle\Entity\PageGroup
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\PageBundle\Entity\PageGroup", inversedBy="pages")
     * @ORM\JoinColumn(name="group_id", referencedColumnName="id", nullable=false)
     */
    private $group;

    /**
     * @var string
     *
     * @ORM\Column(name="title", type="string", length=256)
     * @Assert\NotBlank()
     */
    private $title;

    /**
     * @var string
     *
     * @ORM\Column(name="content", type="text", length=65535)
     * @Assert\NotBlank()
     */
    private $content;

    /**
     * @var int
     *
     * @ORM\Column(name="visitCounter", type="integer", options={"default": "0"})
    */
    private $visitCounter;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateDeleted", type="datetime", nullable=true)
     */
    private $dateDeleted;

    /**
     * @var string
     *
     * @ORM\Column(name="metaTitle", type="string", length=256, nullable=true)
     */
    private $metaTitle;

    /**
     * @var string
     *
     * @ORM\Column(name="metaDescription", type="string", length=512, nullable=true)
     */
    private $metaDescription;

    /**
     * @var string
     *
     * @ORM\Column(name="metaKeywords", type="string", length=256, nullable=true)
     */
    private $metaKeywords;

    /**
     * @var string
     *
     * @ORM\Column(name="metaCanonical", type="string", length=512, nullable=true)
     */
    private $metaCanonical;

    /**
     * @var string
     *
     * @ORM\Column(name="metaImage", type="string", length=256, nullable=true)
     */
    private $metaImage;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=1, options={"default": "A", "fixed" = true})
     */
    private $status;


    // ------------------------------------------------------------
    // Has Lifecycle Callbacks methods.
    // ------------------------------------------------------------

    /**
     * Funkcja wykonuje się podczas wstawiania nowego rekordu do bazy.
     *
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        // Ustawienie daty utworzenia.
        $this->dateCreated = new \DateTime();

        // Ustawienie statusu.
        if (is_null($this->status)) {
            $this->status = 'A';
        }

        // Ustawienie liczby wyświetleńna 0.
        $this->visitCounter = 0;
    }

    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Set id
     *
     * @param int $id
     * @return Page
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     * @return Page
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set content
     *
     * @param string $content
     * @return Page
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }

    /**
     * Get content
     *
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Set visitCounter
     *
     * @param integer $visitCounter
     * @return Page
     */
    public function setVisitCounter($visitCounter)
    {
        $this->visitCounter = $visitCounter;

        return $this;
    }

    /**
     * Get visitCounter
     *
     * @return int
     */
    public function getVisitCounter()
    {
        return $this->visitCounter;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     * @return Page
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set dateDeleted
     *
     * @param \DateTime $dateDeleted
     * @return Page
     */
    public function setDateDeleted($dateDeleted)
    {
        $this->dateDeleted = $dateDeleted;

        return $this;
    }

    /**
     * Get dateDeleted
     *
     * @return \DateTime
     */
    public function getDateDeleted()
    {
        return $this->dateDeleted;
    }

    /**
     * Set metaTitle
     *
     * @param string $metaTitle
     * @return Page
     */
    public function setMetaTitle($metaTitle)
    {
        $this->metaTitle = $metaTitle;

        return $this;
    }

    /**
     * Get metaTitle
     *
     * @return string
     */
    public function getMetaTitle()
    {
        return $this->metaTitle;
    }

    /**
     * Set metaDescription
     *
     * @param string $metaDescription
     * @return Page
     */
    public function setMetaDescription($metaDescription)
    {
        $this->metaDescription = $metaDescription;

        return $this;
    }

    /**
     * Get metaDescription
     *
     * @return string
     */
    public function getMetaDescription()
    {
        return $this->metaDescription;
    }

    /**
     * Set metaKeywords
     *
     * @param string $metaKeywords
     * @return Page
     */
    public function setMetaKeywords($metaKeywords)
    {
        $this->metaKeywords = $metaKeywords;

        return $this;
    }

    /**
     * Get metaKeywords
     *
     * @return string
     */
    public function getMetaKeywords()
    {
        return $this->metaKeywords;
    }

    /**
     * Set metaCanonical
     *
     * @param string $metaCanonical
     * @return Page
     */
    public function setMetaCanonical($metaCanonical)
    {
        $this->metaCanonical = $metaCanonical;

        return $this;
    }

    /**
     * Get metaCanonical
     *
     * @return string
     */
    public function getMetaCanonical()
    {
        return $this->metaCanonical;
    }

    /**
     * Set metaImage
     *
     * @param string $metaImage
     * @return Page
     */
    public function setMetaImage($metaImage)
    {
        $this->metaImage = $metaImage;

        return $this;
    }

    /**
     * Get metaImage
     *
     * @return string
     */
    public function getMetaImage()
    {
        return $this->metaImage;
    }

    /**
     * Set status
     *
     * @param string $status
     * @return Page
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set group
     *
     * @param PageGroup $group
     * @return Page
     */
    public function setGroup(PageGroup $group)
    {
        $this->group = $group;

        return $this;
    }

    /**
     * Get group
     *
     * @return PageGroup
     */
    public function getGroup()
    {
        return $this->group;
    }
}
