<?php

namespace Wi\Admin\PageBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\PageBundle\Entity\PageGroup;

/**
 * Page Group Listener.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class PageGroupListener
{
    /**
     * Metoda jest wykonywana przed usunięciem grupy.
     *
     * @param  PageGroup           $pageGroup
     * @param  LifecycleEventArgs  $event
     */
    public function preRemove(PageGroup $pageGroup, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $pageGroup->setStatus('D');

        // Zapis.
        $em->persist($pageGroup);
        $em->flush();
    }
}
