<?php

namespace Wi\Admin\PageBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\PageBundle\Entity\Page;

/**
 * Page Listener.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class PageListener
{
    /**
     * Metoda jest wykonywana przed usunięciem grupy.
     *
     * @param  Page                $page
     * @param  LifecycleEventArgs  $event
     */
    public function preRemove(Page $page, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $page->setStatus('D');

        // Zapis.
        $em->persist($page);
        $em->flush();
    }
}
