<?php

namespace Wi\Admin\PageBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * PageRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class PageRepository extends EntityRepository
{
    /**
     * Liczba wszystkich aktywnych stron.
     *
     * @return int
     */
    public function countActive()
    {
        $qb = $this->createQueryBuilder('p');

        return (int) $qb
            ->select($qb->expr()->count('p'))
            ->where('p.status = :status')
            ->setParameters([
                'status' => 'A',
            ])
            ->getQuery()
            ->getSingleScalarResult()
        ;
    }

    /**
     * Get pages with limit .
     *
     * @param   int     $limit        Limit of pages.
     * @return  array
     */
    public function findByActivWithLimit($limit = 3)
    {
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('p')
            ->where('p.status = :status')
            ->andWhere('p.dateDeleted IS NULL')
            ->andWhere('p.title != :notitle')
            ->andWhere('p.status = :status')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
            'notitle' => 'ZAREZERWOWANE',
        ];

        return $qb
            ->orderBy('p.id', 'DESC')
            ->setMaxResults($limit)
            ->setParameters($params)
            ->getQuery()
            ->getResult();
        ;
    }

    // -------------------------------------------------------------------------

    public function findForSitemap($ids = [])
    {
        return $this->createQueryBuilder('p')
            ->innerJoin('p.group', 'g')
            ->where('g.id <> :group_id')
            ->orWhere('p.id IN (:ids)')
            ->andWhere('p.status = :status')
            ->setParameters([
                'group_id' => 1,
                'ids' => $ids,
                'status' => 'A',
            ])
            ->orderBy('p.title', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    public function findForSitemapOnlyGroupFirst($ids = [])
    {
        return $this->createQueryBuilder('p')
            ->innerJoin('p.group', 'g')
            ->where('g.id = :group_id')
            ->andWhere('p.id IN (:ids)')
            ->andWhere('p.status = :status')
            ->setParameters([
                'group_id' => 1,
                'ids' => $ids,
                'status' => 'A',
            ])
            ->orderBy('p.title', 'ASC')
            ->getQuery()
            ->getResult()
            ;
    }

    /**
     * Pobiera zapytanie dla wszystkich aktywnych stron.
     *
     * @param   int     $category_id    ID kategorii do filtrowania aktualności.
     *                                  Domyślnie 'null'.
     * @return  Query
     */
    public function getFindAllActiveQuery($search = '')
    {
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('p')
            ->where('p.status = :status')
            ->andWhere('p.dateDeleted IS NULL')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
        ];

        // Jeśli tekst do wyszukania jest przekazany to szukaj.
        if ($search) {
            $params['search'] = '%' . $search . '%';
            $qb->andWhere($qb->expr()->orX(
                $qb->expr()->like('p.title', ':search'),
                $qb->expr()->like('p.content', ':search'),
                $qb->expr()->like('p.metaTitle', ':search'),
                $qb->expr()->like('p.metaDescription', ':search'),
                $qb->expr()->like('p.metaKeywords', ':search'),
                $qb->expr()->like('p.metaCanonical', ':search'),
                $qb->expr()->like('p.metaImage', ':search')
            ));
        }

        return $qb
            ->setParameters($params)
            ->getQuery()
            ;
    }


    /**
     * Wyszukiwanie po tytule.
     *
     * @param string
     * @return array
     */

    public function findByTitleWithSerach($search, $ids = []){
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('p')
            ->where('p.status = :status')
            ->andWhere('p.dateDeleted IS NULL')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
        ];

        if ($search) {
            $params['search'] = '%' . $search . '%';
            $qb->andWhere($qb->expr()->orX(
                $qb->expr()->like('p.title', ':search')
            ));
        }

        return $qb
            ->orderBy('p.title', 'DESC')
            ->setParameters($params)
            ->getQuery()
            ->getResult();
        ;
    }

    /**
     * Wyszukiwanie po tytule.
     *
     * @param string
     * @return array
     */

    public function findByTitleWithSerachPublic($search, $ids = []){
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('p')
            ->innerJoin('p.group', 'g')
            ->where('p.status = :status')
            ->andWhere('p.dateDeleted IS NULL')
            ->andWhere('g.id <> :group_id')
            ->orWhere('p.id IN (:ids)')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
            'group_id' => 1,
            'ids' => $ids,
        ];

        if ($search) {
            $params['search'] = '%' . $search . '%';
            $qb->andWhere($qb->expr()->orX(
                $qb->expr()->like('p.title', ':search')
            ));
        }

        return $qb
            ->orderBy('p.title', 'DESC')
            ->setParameters($params)
            ->getQuery()
            ->getResult();
        ;
    }

    /**
     * Wyszukiwanie dla publicznego użytkownika.
     *
     * @param string
     * @return array
     */

    public function getFindAllActivePublishedQuery($search, $ids = []){
        // Utworzenie QueryBuilder'a.
        $qb = $this->createQueryBuilder('p')
            ->innerJoin('p.group', 'g')
            ->where('p.status = :status')
            ->andWhere('p.dateDeleted IS NULL')
            ->andWhere('g.id <> :group_id')
            ->orWhere('p.id IN (:ids)')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
            'group_id' => 1,
            'ids' => $ids,
        ];

        if ($search) {
            $params['search'] = '%' . $search . '%';
            $qb->andWhere($qb->expr()->orX(
                $qb->expr()->like('p.title', ':search'),
                $qb->expr()->like('p.content', ':search'),
                $qb->expr()->like('p.metaTitle', ':search'),
                $qb->expr()->like('p.metaDescription', ':search'),
                $qb->expr()->like('p.metaKeywords', ':search'),
                $qb->expr()->like('p.metaCanonical', ':search'),
                $qb->expr()->like('p.metaImage', ':search')
            ));
        }

        return $qb
            ->orderBy('p.title', 'DESC')
            ->setParameters($params)
            ->getQuery();
        ;
    }
}
