<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_pages_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pages.Delete')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_delete', array('id' => $page->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.Delete'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-doc-text-1"></i><?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('pagesDelete.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('pagesDelete.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('menuShowSite'); ?>
    <div class="menu-show-site">
        <a  class="button warning tiny" href="<?php echo $view['router']->path('wi_front_page_index', ['id' => $page->getId(), 'slug' => $view['front']->slugify($page->getTitle())]); ?>" title="<?php echo $view['translator']->trans('top-bar.showArticle'); ?>" target="_blank">
            <i class="icon-monitor-1"></i>
            <span>
                <?php echo $view['translator']->trans('top-bar.showArticle'); ?>
            </span>
        </a>
    </div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-doc-remove"></i>
                <span><?php echo $view['translator']->trans('pagesDelete.listSubTitle'); ?> - <?php echo $page->getTitle(); ?></span>
            </h3></div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-12 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesDelete.dataNews'); ?></strong></p>
                    <?php echo $view['form']->start($deleteForm); ?>
                    <?php echo $view['form']->errors($deleteForm); ?>
                    <div class="switch-admin">
                        <?php echo $view['form']->errors($deleteForm['deletePage']); ?>
                        <?php echo $view['form']->widget($deleteForm['deletePage']); ?>
                        <label class="switch-paddle" for="<?php echo $deleteForm->children['deletePage']->vars['id']; ?>">
                            <span class="show-for-sr"><?php echo $view['translator']->trans('pagesDelete.dataNews'); ?></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                    <p><?php echo $view['translator']->trans('pagesDelete.dataNewsSub'); ?>:<br>
                        <strong><?php echo $view['translator']->trans('pagesNew.form.titleTitle'); ?></strong> <?php echo $page->getTitle() ?><br>
                        <strong><?php echo $view['translator']->trans('pagesNew.form.textTitle'); ?></strong>
                        <p><?php echo substr(trim(strip_tags($page->getContent())),0,200); ?> <?php echo (strlen(trim(strip_tags($page->getContent())))>200 ? "..." : ""); ?></p>
                    </p>
                    <button type="submit" id="pagesDeleteInput" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                        <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                    </button>
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_pages_show', array('id' => $page->getId())); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                    </a>
                    <?php echo $view['form']->end($deleteForm); ?>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

