<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_pages_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pages.Show')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_show', ['id' => $page->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.Show'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-doc-text-1"></i><?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('pagesShow.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('pagesShow.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('menuShowSite'); ?>
<div class="menu-show-site">
    <a  class="button warning tiny" href="<?php echo $view['router']->path('wi_front_page_index', ['id' => $page->getId(), 'slug' => $view['front']->slugify($page->getTitle())]); ?>" title="<?php echo $view['translator']->trans('top-bar.showArticle'); ?>" target="_blank">
        <i class="icon-monitor-1"></i>
        <span>
                <?php echo $view['translator']->trans('top-bar.showArticle'); ?>
            </span>
    </a>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowPages-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowPages-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_pages_edit', array('id' => $page->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT') && $page->getGroup()->getId() != 1): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_pages_delete', ['id' => $page->getId()]); ?>">
                                    <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('pagesShow.deleteButton'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-doc-text-1"></i>
                <span><?php echo $view['translator']->trans('catShow.listSubTitle'); ?> - <?php echo $page->getTitle(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesShow.details'); ?>:</strong></p>
                </div>
                <div class="large-10 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesNew.form.titleTitle'); ?>:</strong>
                        <?php echo $page->getTitle(); ?>
                    </p>
                    <p><strong><?php echo $view['translator']->trans('pagesNew.form.dateTitle'); ?>:</strong>
                        <?php if ($page->getDateCreated()): ?>
                            <?php echo $page->getDateCreated()->format('Y-m-d H:i:s'); ?>
                        <?php endif; ?>
                    </p>
                    <p>
                        <strong>
                            <?php echo $view['translator']->trans('pagesNew.form.groupTitle'); ?>:
                        </strong>
                        <?php echo $page->getGroup()->getName(); ?>
                    </p>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesNew.form.textTitle'); ?>:</strong></p>
                </div>
                <div class="large-10 columns">
                    <div class="callout">
                        <?php echo $page->getContent(); ?>
                    </div>
                    <a href="<?php echo $view['router']->path('wi_admin_pages_edit', array('id' => $page->getId())); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                        <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                    </a>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
<div class="box collapsed-box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <span class="box-btn" data-toggle="configShowPagesSEO-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
            <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowPagesSEO-dropdown" data-dropdown data-close-on-click="true">
                <ul class="no-bullet">
                    <li>
                        <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                            <a href="<?php echo $view['router']->path('wi_admin_pages_edit', array('id' => $page->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                            </a>
                        <?php endif; ?>
                    </li>
                </ul>
            </div>
            <span>
                <i class="icon-up-open" data-widget="collapse"></i>
            </span>
        </div>
        <h3 class="box-title" data-widget="collapse"><i class="icon-chart-bar-2"></i>
            <span>
                <?php echo $view['translator']->trans('pagesShow.seosem'); ?>
            </span>
        </h3>
    </div>
    <div class="box-body " style="display: none;">
        <div class="row">
            <div class="large-2 columns"></div>
            <div class="large-10 columns">
                <p><strong><?php echo $view['translator']->trans('pagesNew.form.titleMetaTitle'); ?>:</strong>
                    <?php echo $view['front']->getMetaArrayValues($page)['title']; ?>
                </p>
                <p><strong><?php echo $view['translator']->trans('pagesNew.form.titleMetaDescription'); ?>:</strong>
                    <?php echo $view['front']->getMetaArrayValues($page)['description']; ?>
                </p>
                <p><strong><?php echo $view['translator']->trans('pagesNew.form.titleMetaKeywords'); ?>:</strong>
                    <?php echo $view['front']->getMetaArrayValues($page)['keywords']; ?>
                </p>
                <p><strong><?php echo $view['translator']->trans('pagesNew.form.titleMetaCanonical'); ?>:</strong>
                    <?php echo $view['front']->getMetaArrayValues($page)['canonical']; ?>
                </p>
                <p><strong><?php echo $view['translator']->trans('pagesNew.form.titleMetaImage'); ?>:</strong>
                    <?php echo $view['front']->getMetaArrayValues($page)['image']; ?>
                </p>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

