<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_news_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pagesGroup.List')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_page_groups_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pagesGroup.List'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-doc-text-1"></i>
    <?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('groupList.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('groupList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <?php
    /**
     * Render page groups tree.
     *
     * @return string
     */
    $displayPageGroupsTree = function ($pageGroups, $prefix = '', $html = '') use (&$displayPageGroupsTree, $view) {
        foreach ($pageGroups as $key => $pageGroup) {
            $html .= '
                <tr>
                    <td>' . $prefix . '<i class="icon-down-open-mini" ' . ($pageGroup->getChildren()->count() ? '' : 'style="opacity: 0;"') . '></i>
                        <a href="' . $view['router']->path('wi_admin_page_groups_show', ['id' => $pageGroup->getId()]) . '" title="' . $view['translator']->trans('groupList.showCat') . '"><b>&nbsp;' . $pageGroup->getName() . '</b></a>
                        <div class="buttonItemsBox">
                            <div class="buttonsItems">
                                            <a href="'. $view['router']->path('wi_admin_page_groups_show', ['id' => $pageGroup->getId()]) .'" class="" title="'. $view['translator']->trans('Table.showButton') .'"><i class="icon-eye-1"></i>'. $view['translator']->trans('Table.showButton') .'</a> / ';
                                    if ($view['security']->isGranted('ROLE_PAGES_EDIT') && $pageGroup->getId() != 1){
                                        $html .= '<a href="' .$view['router']->path('wi_admin_page_groups_edit', ['id' => $pageGroup->getId()]) .'" class=""><i class="icon-edit-1"></i>' .$view['translator']->trans('Table.editButton'). '</a> / ';
                                    }
                                    if ($view['security']->isGranted('ROLE_PAGES_EDIT') && $pageGroup->getId() != 1){
                                        $html .= '<a href="' .$view['router']->path('wi_admin_page_groups_delete', ['id' => $pageGroup->getId()]). '" class="b"><i class="icon-cancel-circled-outline"></i>' .$view['translator']->trans('Table.deleteButton'). '</a>';
                                    }

                            $html .=    '</div>
                            </div>

                    </td>';

            $html .= '<td>'. $pageGroup->getDateCreated()->format('Y-m-d') .'
                    </td>
            ';
            if($view['security']->isGranted('ROLE_PAGES_EDIT')){
            $html .= '<td>
                        <div class="OrderNrForm">';
                        if (! is_null($pageGroups->get($key - 1))) {
                            $html .= '<div><a href="'.$view['router']->path('wi_admin_page_groups_update_order', ['id' => $pageGroup->getId(), 'sort_dir' => 'up']).'" class="button secondary tiny"><i class="icon-up-big margin-center"></i></a></div>';
                        } else {
                            $html .= '<div><span class="button disabled secondary tiny"><i class="icon-up-big margin-center"></i></span></div>';
                        }

                        if (! is_null($pageGroups->get($key + 1))) {
                            $html .= '<div><a href="'.$view['router']->path('wi_admin_page_groups_update_order', ['id' => $pageGroup->getId(), 'sort_dir' => 'down']).'" class="button secondary tiny"><i class="icon-down-big margin-center"></i></a></div>';
                        } else {
                            $html .= '<div><span class="button disabled secondary tiny"><i class="icon-down-big margin-center"></i></span></div>';
                        }
                $html .= '</div>
                    </td>';
                };
            $html .= '</tr>';

            // Jeśli są podgrupy.
            if ($pageGroup->getChildren()->count()) {
                $html .= $displayPageGroupsTree($pageGroup->getChildren(), $prefix . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');
            }
        }

        return $html;
    };
    ?>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configPageGroup-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configPageGroup-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_page_groups_new') ?>" title="<?php echo $view['translator']->trans('groupList.add'); ?>">
                                    <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('groupList.add'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-th-list-outline"></i>
                <span><?php echo $view['translator']->trans('groupList.listSubTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="columns tableResp">
                    <table id="groupList" class="row-border unstriped hover" style="width:100%">
                        <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('groupList.table.name'); ?></th>
                            <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                                <th><?php echo $view['translator']->trans('groupList.table.date'); ?></th>
                            <?php endif; ?>
                            <th><?php echo $view['translator']->trans('groupList.table.OrderNr'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php echo $displayPageGroupsTree($pageGroups); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row navigationBottom">
                <div class="columns">
                    <a class="button secondary" href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backListPages'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop(); ?>


<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop(); ?>

