<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_pages_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pagesGroup.Show')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_page_groups_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pagesGroup.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_page_groups_show', ['id' => $pageGroup->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.pagesGroup.Show'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-doc-text-1"></i><?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('groupShow.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('groupShow.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowCategory-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowCategory-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT') && $pageGroup->getId()>1): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_page_groups_edit', array('id' => $pageGroup->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT') && $pageGroup->getId()>1): ?>
                                <a
                                   href="<?php echo $view['router']->path('wi_admin_page_groups_delete', ['id' => $pageGroup->getId()]); ?>">
                                    <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('groupShow.deleteButton'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-folder"></i>
                <span><?php echo $view['translator']->trans('groupShow.listSubTitle'); ?> - <?php echo $pageGroup->getName(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('groupShow.details'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('groupShow.detailsDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <p><strong><?php echo $view['translator']->trans('groupShow.name'); ?>:</strong> <?php echo $pageGroup->getName(); ?></p>
                    <p><strong><?php echo $view['translator']->trans('groupShow.OrderNr'); ?>:</strong> <?php echo $pageGroup->getOrderNr(); ?></p>
                    <p><strong><?php echo $view['translator']->trans('groupShow.DateCreated'); ?>:</strong>
                        <?php if ($pageGroup->getDateCreated()): ?>
                            <?php echo $pageGroup->getDateCreated()->format('Y-m-d H:i:s'); ?>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_page_groups_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop(); ?>
