<?php

namespace Wi\Admin\PdfBundle\Service;

use Mpdf\Mpdf;
use Symfony\Component\HttpFoundation\Response;

class Pdf
{
    private $mpdf;

    private $options = [
        'close' => true,
        'destination' => '',
        'filename' => '',
        'initialise' => true,
        'mode' => 0,
    ];

    private $params = [
        'mode' => '',
        'format' => 'A4', // If landspace format A4 use 'A4-L'
        'default_font_size' => 0,
        'default_font' => '',
        'margin_left' => 0,
        'margin_right' => 0,
        'margin_top' => 0,
        'margin_bottom' => 0,
        'margin_header' => 0,
        'margin_footer' => 0,
        'orientation' => 'P', // P - portrait, L - landspace - use if set manual format, e.g. [100,100]
    ];

    public function __construct(array $params = [], array $options = [])
    {
        $this
            ->setParams($params)
            ->setOptions($options)
            ->createMpdf()
        ;
    }

    // -------------------------------------------------------------------------

    public function generate(string $html, array $options = [])
    {
        $options = array_merge($this->options, $options);
        $this->mpdf->WriteHTML($html, $options['mode'], $options['initialise'], $options['close']);

        return $this->mpdf->Output($options['filename'], $options['destination']);
    }

    public function setTitle(string $text)
    {
        $this->mpdf->SetTitle($text);

        return $this;
    }

    public function render(string $html, array $options = [])
    {
        $response = new Response();
        $response->headers->set('Content-Type', 'application/pdf');
        $response->setContent($this->generate($html, $options));

        return $response;
    }

    // -------------------------------------------------------------------------

    public function setParams(array $params)
    {
        $this->params = array_merge($this->params, $params);

        return $this;
    }

    public function setOptions(array $options)
    {
        $this->options = array_merge($this->options, $options);

        return $this;
    }

    public function createMpdf()
    {
        $this->mpdf = new Mpdf($this->params);

        return $this;
    }

    public function setCss(array $css = [])
    {
        foreach ($css as $val) {
            $this->writeCss($val);
        }

        return $this;
    }

    public function writeCss(string $filepath)
    {
        $this->mpdf->WriteHTML(file_get_contents($filepath), 1);

        return $this;
    }

    public function download()
    {
        $this->setOptions([
            'destination' => 'D',
        ]);

        return $this;
    }
}
