<?php

namespace Wi\Admin\UserBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

/**
 * Avatar controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class AvatarController extends Controller
{
    /**
     * List of avatars.
     *
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction()
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Pobranie listy wszystkich avatarów.
        $avatars = $em->getRepository('WiAdminUserBundle:Avatar')->findBy(
            [],
            ['name' => 'ASC']
        );

        return $this->render('WiAdminUserBundle:Avatar:index.html.php', [
            'avatars' => $avatars,
        ]);
    }
}
