<?php

namespace Wi\Admin\UserBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

/**
 * Log controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LogController extends Controller
{
    /**
     * List of logs.
     *
     * @param   Request $request
     * @return  \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Pobranie listy wszystkich logów.
        $paginator = $this->get('knp_paginator');
        $logs = $paginator->paginate(
            $em->getRepository('WiAdminUserBundle:Log')
                ->getLogsQuery($request->query->get('q')),
            $request->query->getInt('page', 1),
            $request->query->getInt('per_page') ?: 10,
            [
                'wrap-queries' => true,
            ]
        );

        return $this->render('WiAdminUserBundle:Log:index.html.php', [
            'logs' => $logs,
        ]);
    }
}
