<?php

namespace Wi\Admin\UserBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\UserBundle\Entity\BillingData;

/**
 * Załadowanie danych kontaktowych użytkowników.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadBillingDataData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $billingData = $this->getBillingData($data);

            // Przygotowanie do zapisu.
            $manager->persist($billingData);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($billingData));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 26;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\UserBundle\Entity\BillingData
     */
    private function getBillingData(array $data)
    {
        return (new BillingData())
            ->setId($data['id'])
            ->setUser($this->getReference('ub-user-' . $data['user']))
            ->setName($data['name'])
            ->setAddress($data['address'])
            ->setZip($data['zip'])
            ->setCity($data['city'])
            ->setCountry($data['country'])
            ->setNIP($data['NIP'])
        ;
    }
}
