<?php

namespace Wi\Admin\UserBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\UserBundle\Entity\Interest;

/**
 * Załadowanie zainteresowań użytkownika.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadInterestData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $interest = $this->getInterest($data);
            $this->addReference('ub-interest-'.$data['id'], $interest);

            // Przygotowanie do zapisu.
            $manager->persist($interest);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($interest));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 23;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            [
                'id' => 1,
                'name' => 'Ochrona środowiska',
            ],
            [
                'id' => 2,
                'name' => 'Alternatywne źródła energii',
            ],
            [
                'id' => 3,
                'name' => 'Sport',
            ],
            [
                'id' => 4,
                'name' => 'Zdrowe odżywianie',
            ],
            [
                'id' => 5,
                'name' => 'Technologie XXI wieku',
            ],
            [
                'id' => 6,
                'name' => 'Turystyka i rekreacja',
            ],
            [
                'id' => 7,
                'name' => 'Ekologia w przemyśle',
            ],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\UserBundle\Entity\Interest
     */
    private function getInterest(array $data)
    {
        return (new Interest())
            ->setId($data['id'])
            ->setName($data['name'])
        ;
    }
}
