<?php

namespace Wi\Admin\UserBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\UserBundle\Entity\Profile;

/**
 * Załadowanie danych profilowych użytkowników.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadProfileData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $profile = $this->getProfile($data);

            // Przygotowanie do zapisu.
            $manager->persist($profile);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($profile));
            $metadata->setIdGeneratorType(\Doctrine\ORM\Mapping\ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 25;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\UserBundle\Entity\Profile
     */
    private function getProfile(array $data)
    {
        return (new Profile())
            ->setId($data['id'])
            ->setUser($this->getReference('ub-user-' . $data['user']))
            ->setFirstName($data['firstName'])
            ->setLastName($data['lastName'])
            ->setSex($data['sex'])
            ->setDateOfBirth($data['dateOfBirth'])
            ->setDescription($data['description'])
        ;
    }
}
