<?php

namespace Wi\Admin\UserBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Wi\Admin\UserBundle\Entity\LogType;
use Wi\Admin\UserBundle\Entity\User;

/**
 * Log
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Table(
 *      name="user_logs",
 *      indexes={
 *          @ORM\Index(name="IX_Log_User_id", columns={"user_id"}),
 *          @ORM\Index(name="IX_Log_LogType_id", columns={"logType_id"})
 *      }
 * )
 * @ORM\Entity(repositoryClass="Wi\Admin\UserBundle\Repository\LogRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Log
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var Wi\Admin\UserBundle\Entity\User
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\UserBundle\Entity\User", inversedBy="logs")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=true)
     */
    private $user;

    /**
     * @var Wi\Admin\UserBundle\Entity\Log
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\UserBundle\Entity\LogType")
     * @ORM\JoinColumn(name="logType_id", referencedColumnName="id")
     */
    private $logType;

    /**
     * @var int
     *
     * @ORM\Column(name="object_id", type="integer", nullable=true)
     */
    private $objectId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="datetime", type="datetime")
     */
    private $datetime;

    /**
     * @var string
     *
     * @ORM\Column(name="ip", type="string", length=32)
     */
    private $ip;

    /**
     * @var string
     *
     * @ORM\Column(name="host", type="string", length=256)
     */
    private $host;

    /**
     * @var string
     *
     * @ORM\Column(name="descriptions", type="text", nullable=true)
     */
    private $descriptions;


    // ------------------------------------------------------------
    // Has Lifecycle Callbacks methods.
    // ------------------------------------------------------------

    /**
     * Funkcja wykonuje się podczas wstawiania nowego rekordu do bazy.
     *
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        // Ustawienie daty utworzenia.
        $this->setDatetime(new \DateTime());
    }

    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set objectId
     *
     * @param integer $objectId
     * @return Log
     */
    public function setObjectId($objectId)
    {
        $this->objectId = $objectId;

        return $this;
    }

    /**
     * Get objectId
     *
     * @return int
     */
    public function getObjectId()
    {
        return $this->objectId;
    }

    /**
     * Set datetime
     *
     * @param \DateTime $datetime
     * @return Log
     */
    public function setDatetime($datetime)
    {
        $this->datetime = $datetime;

        return $this;
    }

    /**
     * Get datetime
     *
     * @return \DateTime
     */
    public function getDatetime()
    {
        return $this->datetime;
    }

    /**
     * Set ip
     *
     * @param string $ip
     * @return Log
     */
    public function setIp($ip)
    {
        $this->ip = $ip;

        return $this;
    }

    /**
     * Get ip
     *
     * @return string
     */
    public function getIp()
    {
        return $this->ip;
    }

    /**
     * Set host
     *
     * @param string $host
     * @return Log
     */
    public function setHost($host)
    {
        $this->host = $host;

        return $this;
    }

    /**
     * Get host
     *
     * @return string
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * Set descriptions
     *
     * @param string $descriptions
     * @return Log
     */
    public function setDescriptions($descriptions)
    {
        $this->descriptions = $descriptions;

        return $this;
    }

    /**
     * Get descriptions
     *
     * @return string
     */
    public function getDescriptions()
    {
        return $this->descriptions;
    }

    /**
     * Set user
     *
     * @param User $user
     * @return Log
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set logType
     *
     * @param LogType $logType
     * @return Log
     */
    public function setLogType(LogType $logType = null)
    {
        $this->logType = $logType;

        return $this;
    }

    /**
     * Get logType
     *
     * @return Log
     */
    public function getLogType()
    {
        return $this->logType;
    }
}
