<?php

namespace Wi\Admin\UserBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\UserBundle\Entity\BillingData;

/**
 * Billing Data Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BillingDataType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', null, [
                'attr' => [
                    'placeholder' => 'usersEdit.form.name',
                ],
                'label' => 'usersEdit.form.name',
            ])
            ->add('address', null, [
                'attr' => [
                    'placeholder' => 'usersEdit.form.address',
                ],
                'label' => 'usersEdit.form.address',
            ])
            ->add('zip', null, [
                'attr' => [
                    'placeholder' => 'usersEdit.form.zipPlace',
                ],
                'label' => 'usersEdit.form.zip',
            ])
            ->add('city', null, [
                'attr' => [
                    'placeholder' => 'usersEdit.form.city',
                ],
                'label' => 'usersEdit.form.city',
            ])
            ->add('country', null, [
                'attr' => [
                    'placeholder' => 'usersEdit.form.country',
                ],
                'label' => 'usersEdit.form.country',
            ])
            ->add('NIP', null, [
                'attr' => [
                    'placeholder' => 'usersEdit.form.NIPplace',
                ],
                'label' => 'usersEdit.form.NIP',
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => BillingData::class,
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_userbundle_billing_data';
    }


}
