<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_users_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.interest.List')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/users.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.administration'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_users_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.users.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_users_interests_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.interest.List'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-users"></i><?php echo $view['translator']->trans('users.listTitle'); ?> - <?php echo $view['translator']->trans('interestNew.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('interestNew.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title">
            <i class="icon-doc-remove"></i>
            <span><?php echo $view['translator']->trans('sender.delete.boxTitle'); ?> - <?php echo $interest->getName(); ?></span>
        </h3></div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong>Are you sure you want to remove this interest?</strong></p>

                <?php echo $view['form']->start($form); ?>
                <?php echo $view['form']->errors($form); ?>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($form['delete']); ?>
                    <?php echo $view['form']->widget($form['delete']); ?>
                    <label class="switch-paddle" for="delete_delete">
                        <span class="show-for-sr"></span>
                        <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                        <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                    </label>
                </div>
                <button type="submit" id="deleteButton" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                    <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                </button>
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_users_interests_index'); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                </a>
                <?php echo $view['form']->end($form); ?>
            </div>
        </div>
    </div>
</div>

<script>
var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
</script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/users.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
