<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_users_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.logs.List')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/users.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.administration'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_users_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.users.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_users_logs_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.logs.List'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-users"></i><?php echo $view['translator']->trans('users.listTitle'); ?> - <?php echo $view['translator']->trans('userLogs.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('userLogs.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-th-list-outline"></i>
                <span><?php echo $view['translator']->trans('userLogs.listSubTitle'); ?></span>
            </h3>
            <?php echo $view->render('KnpPaginatorBundle/Pagination/search.html.php', [
                'knp_pagination' => $logs,
            ]); ?>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="columns tableResp">
                    <table id="userLogsTable">
                        <thead>
                        <tr>
                            <th><?php echo $view['knp_pagination']->sortable($logs, $view['translator']->trans('userLogs.table.id'), 'l.id'); ?></th>
                            <th><?php echo $view['translator']->trans('userLogs.table.type'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($logs, $view['translator']->trans('userLogs.table.email'), 'lu.email'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($logs, $view['translator']->trans('userLogs.table.firstName'), 'lup.firstName'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($logs, $view['translator']->trans('userLogs.table.lastName'), 'lup.lastName'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($logs, $view['translator']->trans('userLogs.table.datetime'), 'l.datetime'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($logs, $view['translator']->trans('userLogs.table.name'), 'lt.name'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($logs as $log): ?>
                            <?php
                            $user = $log->getUser();
                            $profile = null;

                            if (! is_null($user)) {
                                $profile = ($user->getProfile()->count() > 0) ? $user->getProfile()->first() : null;
                            }
                            ?>
                            <tr>
                                <td><?php echo $log->getId(); ?></td>
                                <td>
                                    <?php if($log->getLogType()->getType()=='I'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.info'); ?>
                                    <?php elseif ($log->getLogType()->getType()=='W'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.warning'); ?>
                                    <?php elseif ($log->getLogType()->getType()=='S'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.success'); ?>
                                    <?php elseif ($log->getLogType()->getType()=='E'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.error'); ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if (! is_null($user)): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_users_show', ['id' => $user->getId()]); ?>" title="<?php echo $user->getEmail(); ?>"><?php echo $user->getEmail(); ?></a>
                                        <div class="buttonItemsBox">
                                            <div class="buttonsItems">
                                                <a href="<?php echo $view['router']->path('wi_admin_users_show', ['id' => $user->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if (! is_null($profile)): ?>
                                        <?php echo $profile->getFirstName(); ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if (! is_null($profile)): ?>
                                        <?php echo $profile->getLastName(); ?>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo $log->getDatetime()->format('Y-m-d H:i:s'); ?></td>
                                <td><?php echo $log->getLogType()->getName(); ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="medium-6 columns"></div>
                <div class="medium-6 columns paginationBox">
                    <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                        'knp_pagination' => $logs,
                    ]); ?>

                    <?php echo $view['knp_pagination']->render($logs); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-12 columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_users_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/users.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
