<?php 

namespace Wi\Admin\UserBundle\Validator\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Birthday Pesel Validator.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BirthdayPeselValidator extends ConstraintValidator
{
    /**
     * Validate date of birth based on date of birth in PESEL.
     *
     * @param mixed $value
     * @param Constraint $constraint
     */
    public function validate($value, Constraint $constraint)
    {
        $valid = true;
        $pesel = $this->context->getRoot()->get('pesel')->getData();

        if (! empty($value)) {
            if (! empty($pesel)) {
                $year = (int) substr($pesel, 0, 2);
                $month = (int) substr($pesel, 2, 2);
                $day = (int) substr($pesel, 4, 2);

                if (($month >= 1) && ($month <= 12)) { // 1900 - 1999
                    $year += 1900;
                } else if (($month >= 81) && ($month <= 92)) { // 1800 - 1899
                    $year += 1800;
                    $month = $month - 80;
                } else if (($month >= 21) && ($month <= 32)) { // 2000 - 2099
                    $year += 2000;
                    $month -= 20;
                } else if (($month >= 41) && ($month <= 52)) {
                    $year += 2100;
                    $month -= 40;
                }

                $birthdayPesel = new \DateTime($year . '-' . $month . '-' . $day);

                $valid = $value == $birthdayPesel;
            }
        }

        if (! $valid) {
            $this->context->addViolation($constraint->message);
        }
    }
}
