<?php

namespace Wi\Admin\UserBundle\Validator\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Pesel Validator.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class PeselValidator extends ConstraintValidator
{
    /**
     * @var array
     */
    private $peselWeights = [9, 7, 3, 1, 9, 7, 3, 1, 9, 7];

    /**
     * @param mixed $value
     * @param Constraint $constraint
     */
    public function validate($value, Constraint $constraint)
    {
        $valid = true;

        if (! empty($value)) {
            if (strlen($value) == 11 && ctype_digit($value)) {
                $sum = 0;

                for ($i = 0; $i < 10; $i++) {
                    $sum += $value[$i] * $this->peselWeights[$i];
                }

                $valid = ($sum % 10) == $value[10];

                if ($valid) {
                    $year = (int) substr($value, 0, 2);
                    $month = (int) substr($value, 2, 2);
                    $day = (int) substr($value, 4, 2);

                    if (($month >= 1) && ($month <= 12)) { // 1900 - 1999
                        $year += 1900;
                    } else if (($month >= 81) && ($month <= 92)) { // 1800 - 1899
                        $year += 1800;
                        $month = $month - 80;
                    } else if (($month >= 21) && ($month <= 32)) { // 2000 - 2099
                        $year += 2000;
                        $month -= 20;
                    } else if (($month >= 41) && ($month <= 52)) {
                        $year += 2100;
                        $month -= 40;
                    }

                    $now = new \DateTime();
                    $birthday = new \DateTime($year . '-' . $month . '-' . $day);

                    $valid = checkdate($month, $day, $year) && ($now > $birthday);
                }
            } else {
                $valid = false;
            }
        }

        if (! $valid) {
            $this->context->addViolation($constraint->message);
        }
    }
}
