<?php

namespace Wi\Admin\UserBundle\Validator\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Sex Pesel Validator.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class SexPeselValidator extends ConstraintValidator
{
    /**
     * Validate sex based on sex in PESEL.
     *
     * @param mixed $value
     * @param Constraint $constraint
     */
    public function validate($value, Constraint $constraint)
    {
        $valid = true;
        $pesel = $this->context->getRoot()->get('pesel')->getData();

        if (! empty($value)) {
            if (! empty($pesel)) {
                $sexPesel = (int) $pesel[9];
                $sexBasedPesel = null;

                if ($sexPesel % 2 == 1) {
                    $sexBasedPesel = 'M';
                } else {
                    $sexBasedPesel = 'F';
                }

                $valid = $value == $sexBasedPesel;
            }
        }

        if (! $valid) {
            $this->context->addViolation($constraint->message);
        }
    }
}
