<?php

namespace Wi\Front\CoreBundle\Controller;

use Wi\Front\CoreBundle\Core\Controller\FrontController;
use Wi\Admin\CoreBundle\Service\Sitemap;
use Wi\Admin\CoreBundle\Service\Config;
use Wi\Admin\NewsBundle\Entity\Category;

/**
 * Index controller.
 *
 * @author Piotr Krzok <piotr.krzok@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class IndexController extends FrontController
{
    /**
     * Sitemap.
     *
     * @param Sitemap $sitemap
     * @param Config $config
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Sitemap $sitemap, Config $config)
    {

        $em = $this->getDoctrine()->getManager();

        // Pobranie konfiguracji do generowania indexu.
        $params = [
            'showImagePublicIndex' => boolval(intval($config->get('sitemap.showImagePublicIndex'))),
            'splitPagesPerGroup' => boolval(intval($config->get('sitemap.splitPagesPerGroup'))),
            'splitNewsPerCategory' => boolval(intval($config->get('sitemap.splitNewsPerCategory'))),
            'splitNewsPerMonth' => boolval(intval($config->get('sitemap.splitNewsPerMonth'))),
        ];

        if($params['splitPagesPerGroup']){
            // Pobieranie grup stron.
            $groups = $em->getRepository('WiAdminPageBundle:PageGroup')->findAll();
            $pagesPref = $em->getRepository('WiAdminPageBundle:Page')->findForSitemapOnlyGroupFirst(Sitemap::PAGE_IDS);
            $pages = null;
        } else {
            // Pobranie listy stron pages/article.
            $pages = $em->getRepository('WiAdminPageBundle:Page')->findForSitemap(Sitemap::PAGE_IDS);
            $groups = null;
            $pagesPref = null;
        }

        // Pobranie listy kategorii.
        $categories = $em->getRepository('WiAdminNewsBundle:Category')->findAll();


        return $this->render('WiFrontCoreBundle:Index:index.html.twig', array(
            'categories' => $categories,
            'groups' => $groups,
            'pages' => $pages,
            'pagesPref' => $pagesPref,
            'params' => $params,
        ));
    }

    /**
     * Sitemap.
     *
     * @param Category $category
     * @param Config $config
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function newsCategoryAction(Category $category, Sitemap $sitemap, Config $config)
    {

        $em = $this->getDoctrine()->getManager();

        // Pobranie konfiguracji do generowania indexu.
        $params = [
            'showImagePublicIndex' => boolval(intval($config->get('sitemap.showImagePublicIndex'))),
            'splitNewsPerMonth' => boolval(intval($config->get('sitemap.splitNewsPerMonth'))),
        ];

        return $this->render('WiFrontCoreBundle:Index:newsCategory.html.twig', array(
            'category' => $category,
            'params' => $params,
        ));
    }

}
