<?php

namespace Wi\Front\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Wi\Front\CoreBundle\Core\Controller\FrontController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Wi\Admin\NewsBundle\Entity\News;

class SearchController extends FrontController
{
    public function getAutocompleteDataAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        $search = $request->get('search');

        $data = [];

        $news = $em->getRepository('WiAdminNewsBundle:News')->findByTitleWithSerachPublic($search, News::TYPE_NEWS);

        if($news){
            foreach ($news as $item){
                $data[] = [
                    'label' => $item->getTitle(),
                    'category' => 'News',
                    'typ' => 'news',
                    'id' => $item->getId(),
                    'slug' => $this->slugify($item->getTitle())
                ];
            }
        }

        $blog = $em->getRepository('WiAdminNewsBundle:News')->findByTitleWithSerachPublic($search, News::TYPE_BLOG);

        if($blog){
            foreach ($blog as $item){
                $data[] = [
                    'label' => $item->getTitle(),
                    'category' => 'Blog Post',
                    'typ' => 'blog',
                    'id' => $item->getId(),
                    'slug' => $this->slugify($item->getTitle())
                ];
            }
        }

        $pages = $em->getRepository('WiAdminPageBundle:Page')->findByTitleWithSerachPublic($search, []);

        if($pages){
            foreach ($pages as $page){
                $data[] = [
                    'label' => $page->getTitle(),
                    'category' => 'Pages',
                    'typ' => 'page',
                    'id' => $page->getId(),
                    'slug' => $this->slugify($page->getTitle())
                ];
            }
        }


        return new JsonResponse($data);
    }

    public function indexAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        $search = false;
        if ($request->get('search')){
            $search = $request->get('search');
        }

        $news = null;
        $blog = null;
        $pages = null;
        if ($search){
            // Pobranie wszystkich aktywnych aktualności.
            $paginator = $this->get('knp_paginator');
            $news = $paginator->paginate(
                $em->getRepository('WiAdminNewsBundle:News')
                    ->getFindAllActivePublishedQuery(
                        News::TYPE_NEWS,
                        null,
                        $search
                    ),
                $request->query->getInt('page-news', 1),
                7,
                ['pageParameterName' => 'page-news']
            );
            $blog = $paginator->paginate(
                $em->getRepository('WiAdminNewsBundle:News')
                    ->getFindAllActivePublishedQuery(
                        News::TYPE_BLOG,
                        null,
                        $search
                    ),
                $request->query->getInt('page-blog', 1),
                7,
                ['pageParameterName' => 'page-blog']
            );
            $pages = $paginator->paginate(
                $em->getRepository('WiAdminPageBundle:Page')
                    ->getFindAllActivePublishedQuery($search, []),
                $request->query->getInt('page-page', 1),
                7,
                ['pageParameterName' => 'page-page']
            );
        }

        return $this->render('WiFrontCoreBundle:Search:index.html.twig', [
            'search' => $search,
            'news' => $news,
            'blog' => $blog,
            'pages' => $pages
        ]);
    }

}
