<?php

namespace Wi\Front\CoreBundle\Twig\Extension;

/**
 * Zestaw dodatkowych filtrów do rzutowania zmiennych do danego typu.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class TypecastExtension extends \Twig_Extension
{
    /**
     * {@inheritdoc}
     */
    public function getFilters()
    {
        return [
            new \Twig_SimpleFilter('bool', [$this, 'castToBool']),
            new \Twig_SimpleFilter('b', [$this, 'castToBool']),
            new \Twig_SimpleFilter('float', [$this, 'castToFloat']),
            new \Twig_SimpleFilter('f', [$this, 'castToFloat']),
            new \Twig_SimpleFilter('int', [$this, 'castToInt']),
            new \Twig_SimpleFilter('i', [$this, 'castToInt']),
            new \Twig_SimpleFilter('string', [$this, 'castToString']),
            new \Twig_SimpleFilter('s', [$this, 'castToString']),
        ];
    }

    /**
     * Rzutowanie zmiennej do typu BOOL.
     *
     * @param mixed $var
     * @return bool
     */
    public function castToBool($var) : bool
    {
        return boolval($var);
    }

    /**
     * Rzutowanie zmiennej do typu FLOAT.
     *
     * @param mixed $var
     * @return float
     */
    public function castToFloat($var) : float
    {
        return floatval($var);
    }

    /**
     * Rzutowanie zmiennej do typu INT.
     *
     * @param mixed $var
     * @return int
     */
    public function castToInt($var) : int
    {
        return intval($var);
    }

    /**
     * Rzutowanie zmiennej do typu STRING.
     *
     * @param mixed $var
     * @return string
     */
    public function castToString($var) : string
    {
        return (string) $var;
    }
}
