<?php

namespace Wi\Front\CoreBundle\Utils;

/**
 * Slugger.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class Slugger
{
    /**
     * Transliteration callback for slugs
     *
     * @var callable
     */
    private $transliterator = ['Gedmo\Sluggable\Util\Urlizer', 'transliterate'];

    /**
     * Urlize callback for slugs
     *
     * @var callable
     */
    private $urlizer = ['Gedmo\Sluggable\Util\Urlizer', 'urlize'];

    /**
     * Slugify.
     *
     * @param   string $string
     * @return  string
     */
    public function slugify($string)
    {
        return call_user_func_array(
            $this->urlizer, [
                call_user_func_array(
                    $this->transliterator, [
                        $string
                    ]
                )
            ]
        );
    }
}
