<?php

namespace Wi\Front\LinkBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Wi\Admin\LinkBundle\Entity\Link;

/**
 * Link controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LinkController extends Controller
{
    /**
     * Obsługa skróconych linków.
     *
     * @param Link $link
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function indexAction(Link $link)
    {
        switch ($link->getStatus()) {
            case Link::STATUS_ACTIVE: // Aktywny (301)
                $link->setCount($link->getCount() + 1);

                // Utworzenie instancji EntityManager-a.
                $em = $this->getDoctrine()->getManager();
                $em->persist($link);
                $em->flush($link);
                break;
            case Link::STATUS_DISABLED_NOT_FOUND: // Wyłączony (404)
                throw $this->createNotFoundException('Not found');
                break;
            case Link::STATUS_DISABLED_REDIRECT: // Wyłączony (302)
                return $this->redirectToRoute('homepage');
                // no break
            default:
                break;
        }

        return $this->redirect($link->getUrlWithUtm(), 301);
    }
}
