<?php

namespace Wi\Front\UserBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\UserBundle\Entity\BillingData;

/**
 * Billing Data Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class BillingDataType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'attr' => [
                    'maxlength' => 128,
                ],
                'required' => false,
            ])
            ->add('address', TextType::class, [
                'attr' => [
                    'maxlength' => 128,
                ],
                'required' => false,
            ])
            ->add('zip', TextType::class, [
                'attr' => [
                    'maxlength' => 16,
                ],
                'required' => false,
            ])
            ->add('city', TextType::class, [
                'attr' => [
                    'maxlength' => 64,
                ],
                'required' => false,
            ])
            ->add('country', TextType::class, [
                'attr' => [
                    'maxlength' => 64,
                ],
                'required' => false,
            ])
            ->add('NIP', TextType::class, [
                'attr' => [
                    'maxlength' => 16,
                ],
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => BillingData::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_front_userbundle_billingdata';
    }

}
