<?php

namespace Wi\Front\UserBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\UserBundle\Entity\Profile;

/**
 * Profile Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ProfileType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('firstName', TextType::class, [
                'attr' => [
                    'maxlength' => 64,
                ],
                'required' => false,
            ])
            ->add('lastName', TextType::class, [
                'attr' => [
                    'maxlength' => 64,
                ],
                'required' => false,
            ])
            ->add('sex', ChoiceType::class, [
                'attr' => [],
                'choices' => [
                    'Male' => 'M',
                    'Female' => 'F',
                ],
                'required' => false,
            ])
            ->add('dateOfBirth', DateType::class, [
                'attr' => [],
                'format' => 'dd-MM-yyyy',
                'html5' => false,
                'required' => false,
                'widget' => 'single_text',
            ])
            ->add('description', TextareaType::class, [
                'attr' => [
                    'maxlength' => 65535,
                    'rows' => 10,
                ],
                'required' => false,
            ])
            ->add('pesel', TextType::class, [
                'attr' => [
                    'maxlength' => 16,
                ],
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Profile::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_front_userbundle_profile';
    }

}
