<?php

namespace Wi\Front\UserBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\UserBundle\Entity\User;

/**
 * Reset Password Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ResetPasswordType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('password', RepeatedType::class, [
                'invalid_message' => 'Podane hasłą muszą być takie same.',
                'error_bubbling' => true,
                'first_options' => [
                    'attr' => [
                        'class' => '',
                        'placeholder' => 'Hasło',
                    ],
                    'label' => 'Hasło',
                ],
                'required' => false,
                'second_options' => [
                    'attr' => [
                        'class' => '',
                        'placeholder' => 'Powtórz hasło',
                    ],
                    'label' => 'Powtórz hasło',
                ],
                'type' => PasswordType::class,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => User::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_front_userbundle_reset_password';
    }

}
