<?php

namespace Wi\Front\UserBundle\Form;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\UserBundle\Entity\User;

/**
 * User Interest Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class UserInterestType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('interests', EntityType::class, [
                'class' => 'WiAdminUserBundle:Interest',
                'choice_attr' => function ($val, $key, $index) use ($options) {
                    $attr = [];

                    if (! empty($options['data']->getUserInterests())) {
                        foreach ($options['data']->getUserInterests() as $userIntrest) {
                            if ($userIntrest->getInterest()->getId() == $val->getId()) {
                                $attr['checked'] = true;
                            }
                        }
                    }

                    return $attr;
                },
                'choice_label' => 'name',
                'expanded' => true,
                'label' => false,
                'mapped' => false,
                'multiple' => true,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => User::class,
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_front_userbundle_userinterest';
    }
}
