<?php

namespace Wi\Front\UserBundle\Utils;

use Doctrine\ORM\EntityManagerInterface;
use Wi\Admin\UserBundle\Entity\Log;

/**
 * Logger.
 *
 * Class to save user logs from the application.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class Logger
{
    /**
     * Entity Manager.
     *
     * @var EntityManagerInterface
     */
    private $em;


    /**
     * Construct.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * Create and save log to database.
     *
     * @param int $type_id
     * @param array $params
     */
    public function create($type_id, $params)
    {
        // Create new log entity.
        $log = new Log();

        // Get logType.
        $logType = $this->em
            ->getRepository('WiAdminUserBundle:LogType')
            ->findOneById($type_id)
        ;

        // Set opitons.
        $log
            ->setLogType($logType)
            ->setIp($params['ip'])
            ->setHost($params['host'])
        ;

        // Set user is not empty.
        if (! empty($params['user_id'])) {
            $user = $this->em
                ->getRepository('WiAdminUserBundle:User')
                ->findOneById($params['user_id'])
            ;

            $log->setUser($user);
        }

        // Set user is not empty.
        if (! empty($params['username'])) {
            $user = $this->em
                ->getRepository('WiAdminUserBundle:User')
                ->findOneByEmail($params['username'])
            ;

            $log->setUser($user);
        }

        // Set object_id is not empty.
        if (! empty($params['object_id'])) {
            $log->setObjectId($params['object_id']);
        }

        // Set descriptions is not empty.
        if (! empty($params['descriptions'])) {
            $log->setDescriptions($params['descriptions']);
        }

        // Prepare to save.
        $this->em->persist($log);

        // Save.
        $this->em->flush();
    }
}
