
$(function () {
    "use strict";
    $('.goToFolder').click(function () {
        var url = $(this).attr('paramUrl');
        location.href = url;
    });

    // media - zatrzymanie wywołania slkryptów
    $('.stopPropagation').click(function (event) {
        event.stopPropagation();

    });

    // Stop propagation na button opcje
    $('.buttonOpcje').on('click', function (event) {
        event.stopPropagation();
        var id = $(this).attr('data-toggle');
        $('#' + id).foundation('open');
    });

    //style dla pola drag & drop
    $('#dropdown').bind('dragenter', function() {
        $(this).css("border", "5px dashed #000000");
    });

    $('#dropdown').bind('dragleave', function() {
        $(this).css("border", "none");
    });


    //wyświetlanie szczegółów plików
    $('.plikPlik').bind('click', function (e) {
        var nameFile = $('.dataFile', this).attr('data-nameFile');
        var typeFile = $('.dataFile', this).attr('data-typeFile');
        var urlFile = $('.dataFile', this).attr('data-urlFile');
        var dimensionFileW = $('.dataFile', this).attr('data-dimensionFileW');
        var dimensionFileH = $('.dataFile', this).attr('data-dimensionFileH');
        var sizeFile = $('.dataFile', this).attr('data-sizeFile');
        var dataI = $('.dataFile', this).attr('data-i');

        $('#fileName').text(nameFile);
        if(typeFile=='jpg' || typeFile=='jepg' || typeFile=='png'){
            $('#fileImg').attr('src', urlFile);
        } else {
            $('#fileImg').removeAttr('src');
        }
        $('#fileSize').text(sizeFile);
        $('#fileDimensionsW').text(dimensionFileW);
        $('#fileDimensionsH').text(dimensionFileH);
        $('#fileTyp').text(typeFile);
        $('#fileUrl').val(urlFile);
        $('#downloadButton').attr('href', urlFile).attr('download', nameFile).addClass('widoczny');
        $('#renameButton').attr('data-open', 'zmien'+dataI).attr('aria-controls', 'zmien'+dataI).addClass('widoczny');
        $('#deleteButton').attr('data-open', 'deleteFile'+dataI).attr('aria-controls', 'deleteFile'+dataI).addClass('widoczny');
        var target = $( e.target );
        if(! target.is ("button")){
            $('#modalInfoFile').foundation('open');
        }
    });

    //kopiowanie URL
    $('#fileUrl').bind('click', function () {
        this.select();
        document.execCommand('copy');
        $('.infoCopyUrl').css('opacity', '1').animate({opacity: '0'}, 3000);
        //$('.infoCopyUrl').animate({opacity: '1'}, 3000);

    })
});

$(function () {
    "use strict";
    // Przesyłanie plików.
    var uploader = new plupload.Uploader({
        browse_button: 'drop-area',
        url: Routing.generate('wi_admin_media_upload', { d: directory }),
        chunk_size: '200kb',
        max_retries: 3,
        drop_element: 'dropdown',
        unique_names: false,
        multi_selection: false,
        filters: {
            mime_types : [
                { title : "Image files", extensions : "avi,jpeg,jpg,mp3,mp4,pdf,png,rar,zip" }
            ]
        },
        init: {
            PostInit: function() {
            },
            FilesAdded: function (up, files) {
                plupload.each(files, function (file) {
                    $('#choosen-file').html(file.name);
                });

                uploader.start();
            },
            FileUploaded: function(up, file, info) {
                var response = JSON.parse(info.response);

                if (response.OK == 0) {
                    alert(response.info);
                    file.status = plupload.FAILED;
                    up.trigger('UploadProgress', file);
                }
            },
            ChunkUploaded: function(up, file, info) {
                var response = JSON.parse(info.response);

                if (response.OK == 0) {
                    alert(response.info);
                    file.status = plupload.FAILED;
                    up.trigger('UploadProgress', file);
                }
            },
            UploadProgress: function(up, file) {
                $('#percent').html(file.percent + '%');
            },
            UploadComplete: function (up, files) {
                location.reload();
            }
        }
    });

    // Inicjalizacja mechanizmu do przesyłania plików.
    uploader.init();

});