google.charts.load('current', {packages: ['corechart', 'bar']});

var dayNext = '';
var dayPrev = '';
var monthNext = '';
var monthPrev = '';
var currentDay = '';
var currentMonth = '';

$(function () {
    statisticAjax('daily');

    $('#daily_prev').click(function (e) {
        statisticAjax('daily', dayPrev);
    });
    $('#daily_next').click(function (e) {
        statisticAjax('daily', dayNext);
    });

    $('#monthly_prev').click(function (e) {
        statisticAjax('monthly', monthPrev);
    });
    $('#monthly_next').click(function (e) {
        statisticAjax('monthly', monthNext);
    });

    $('#daily-label').click(function (e) {
        statisticAjax('daily', currentDay);
    });
    $('#monthly-label').click(function (e) {
        statisticAjax('monthly', currentMonth);
    });
    $('#campaign-label').click(function (e) {
        statisticAjax('campaign');
    });
});

function statisticAjax(type, date = '') {
    $.ajax({
        url: Routing.generate('wi_admin_newsletter_mainsite_statistics', {id: campaign_id}),
        method: 'GET',
        data: {
            'type': type,
            'date': date,
        },
        type: 'JSON',
        success: function (result) {
            if (type == 'daily') {
                currentDay = result.curr_day;
                document.getElementById('curr_day').innerHTML = currentDay;

                dailyData = result.data;
                dayNext = result.next_day;
                dayPrev = result.prev_day;

                google.charts.setOnLoadCallback(drawDaily);
            } else if (type == 'monthly') {
                currentMonth = result.curr_month;
                document.getElementById('curr_month').innerHTML = currentMonth;

                monthlyData = result.data;
                monthNext = result.next_month;
                monthPrev = result.prev_month;

                google.charts.setOnLoadCallback(drawMonthly);
            } else if (type == 'campaign') {
                campaignData = [];

                for (var i = result.data.length - 1; i >= 0; i--) {
                    var res = result.data[i];
                    campaignData.push([new Date(res.date), res.messages, res.tooltip]);
                }

                google.charts.setOnLoadCallback(drawCampaign);
            }
        }
    });
}

function drawDaily() {
    var data = new google.visualization.DataTable();
    data.addColumn('string', 'Hour');
    data.addColumn('number', 'Sent');
    data.addColumn({type: 'string', role: 'tooltip', 'p': {'html': true}});
    data.addRows(dailyData);

    var options = {
        hAxis: {
            title: 'Daily Statistics',
        },
        legend: 'none',
        isStacked: true,
        vAxis: {
            viewWindow: {
                min: 0
            },
        },
        tooltip: {isHtml: true},
        width: '100%',
    };

    var chart = new google.visualization.ColumnChart(document.getElementById('daily-chart'));
    chart.draw(data, options);
}

function drawMonthly() {
    var data = new google.visualization.DataTable();
    data.addColumn('string', 'Date');
    data.addColumn('number', 'Sent');
    data.addColumn({type: 'string', role: 'tooltip', 'p': {'html': true}});
    data.addRows(monthlyData);

    var options = {
        hAxis: {
            title: 'Monthly Statistics',
        },
        legend: 'none',
        isStacked: true,
        vAxis: {
            viewWindow: {
                min: 0
            },
        },
        tooltip: {isHtml: true},
    };

    var chart = new google.visualization.ColumnChart(document.getElementById('monthly-chart'));
    chart.draw(data, options);
}

function drawCampaign() {
    var data = new google.visualization.DataTable();
    data.addColumn('date', 'Hour');
    data.addColumn('number', 'Sent');
    data.addColumn({type: 'string', role: 'tooltip', 'p': {'html': true}});
    data.addRows(campaignData);

    var options = {
        hAxis: {
            title: 'Campaign Statistics',
            format: 'yyyy-MM-dd',
        },
        legend: 'none',
        isStacked: true,
        vAxis: {
            viewWindow: {
                min: 0
            },
        },
        tooltip: {isHtml: true},
    };

    var chart = new google.visualization.ColumnChart(document.getElementById('campaign-chart'));
    chart.draw(data, options);
}
