$(function () {
    "use strict";

    // Generator mapy Google
    var googleLat = ($('.googlemaps').length > 0 ? parseFloat($('.googlemaps').attr('data-lat')) : null);
    var googleLng = ($('.googlemaps').length > 0 ? parseFloat($('.googlemaps').attr('data-lng')) : null);
    var googleZoom = ($('.googlemaps').length > 0 ? parseInt($('.googlemaps').attr('data-zoom')) : 11);
    var googlePinInfo = ($('.pinWindowShow').length > 0 ? $('.pinWindowShow').html() : '');

    $(window).on('load', function () {
        if($('.googlemaps').length > 0){
            initMap(googleLat, googleLng, googleZoom, googlePinInfo);
        }
    });

});

// mapy Google
function initMap(googleLat, googleLng, googleZoom, googlePinInfo) {
    var center = {lat: googleLat, lng: googleLng, };
    var map = new google.maps.Map(document.getElementById('googleMaps'), {
        zoom: googleZoom,
        center: center,
    });
    var marker = new google.maps.Marker({
        map: map,
        draggable: false,
        position: center
    });
    var infowindow = new google.maps.InfoWindow({
        content: googlePinInfo
    });
    marker.addListener('click', function() {
        infowindow.open(map, marker);
    });
}
